	%  LP-> BS Cauer
	clear all, clc
	close all
	
	% Requirements for the digital bandstop filter
	wc1T = 0.4*pi;		wc2T = 0.7*pi;
	ws1T = 0.52*pi;		ws2T = 0.6*pi;
	Amax = 0.1;			Amin = 60;		T = 1;
	% Requirements for the analog prototype lowpass filter
	wac1 = (2/T)*tan(wc1T/2);	wac2 = (2/T)*tan(wc2T/2);
	was1 = (2/T)*tan(ws1T/2);	was2 = (2/T)*tan(ws2T/2);	
	was1 = wac1*wac2/was2;		% We select
	% Band edges for the analog lowpass filter
	Omegac = (T/2)*wac1*wac2/(wac2 - wac1);
	Omegas = (T/2)*wac1*wac2/(was2 - was1);	
	% Design of the analog Cauer filter with constant pole radius
	N = CA_CONST_R_ORDER_S(Omegac,Omegas, Amin)
	N = 5;	% We must select an integer order
	[Ga,Za,R_ZEROS,Pa,Wsnew] = CA_CONST_R_POLES_S(Omegac,Omegas,Amin, N);
	% Transformation the analog filter into a digital lowpass filter
	[G, Z, P] = PZ_2_PZ_Z(Ga, Za, Pa, Omegac*T);	
	% Transformation the digital lowpass filter into a digital bandstop filter
	[Gbs, Zbs, Pbs] = PZ_2_BS_Z(G, Z, P, wc1T, wc2T, Omegac*T);	

	figure(1), PLOT_PZ_Z(Zbs, Pbs)
	[S1num,S1den,S2num,S2den] = SORT_LATTICE_POLES_BP_Z(Pbs)
	
	%	figure(3), PLOT_PZ_Z(1./Peven, Peven)
	figure(2), wT = linspace(0, pi, 1000);
	[alfa_odd, alfa_even] = CASCADE_RICHARDS_SECTIONS(S1den, S2den)
	[S1, S2] = LATTICE_RICHARDS_H(alfa_odd, alfa_even, wT);
	Att = MAG_2_ATT(0.5*(S2+S1));
	subplot(2,1,1), PLOT_ATT_Z(wT, Att, pi, 70)						
	
	for n = 1:2*N
		Pbs(n)
		F = abs(atan(imag(Pbs(n))/real(Pbs(n))))	
	end
	
